/*
 * @(#)GetConfigChangesHandler.java	1.2 08/25/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import com.sun.messaging.jmq.util.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;

public class GetConfigChangesHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public GetConfigChangesHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(BrokerAddress sender, GPacket pkt) {
        if (DEBUG)
            logger.log(logger.DEBUG, "GetConfigChangesHandler");

        if (pkt.getType() == ProtocolGlobals.G_GET_CONFIG_CHANGES_REQUEST) {
            handleGetConfigChanges(sender, pkt);
        }
        else if (pkt.getType() ==
            ProtocolGlobals.G_GET_CONFIG_CHANGES_REPLY) {
            handleGetConfigChangesReply(sender, pkt);
        }
        else {
            logger.log(logger.WARNING, "GetConfigChangesHandler " +
                "Internal error : Cannot handle this packet :" +
                pkt.toLongString());
        }
    }

    public void handleGetConfigChanges(BrokerAddress sender, GPacket pkt) {
        long timestamp = ((Long) pkt.getProp("TS")).longValue();
        p.receiveConfigChangesRequest(sender, timestamp);
    }

    public void handleGetConfigChangesReply(BrokerAddress sender,
        GPacket pkt) {
        long timestamp = ((Long) pkt.getProp("TS")).longValue();
        int c = ((Integer) pkt.getProp("C")).intValue();

        byte[] buf = null;
        if (pkt.getPayload() != null)
            buf = pkt.getPayload().array();

        p.receiveConfigChangesReply(sender, timestamp, c, buf);
    }
}


/*
 * EOF
 */
