/*
 * @(#)ClientClosedHandler.java	1.2 02/16/05
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import java.io.*;
import com.sun.messaging.jmq.jmsserver.util.*;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.*;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;

public class ClientClosedHandler extends GPacketHandler {
    public static boolean DEBUG = false;

    public ClientClosedHandler(RaptorProtocol p) {
        super(p);
    }

    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (DEBUG)
            logger.log(logger.DEBUG, "ClientClosedHandler");

        if (pkt.getType() == ProtocolGlobals.G_CLIENT_CLOSED) {
            ConnectionUID conid;
            conid = new ConnectionUID(((Long) pkt.getProp("I")).longValue());

            cb.clientDown(conid);

            if (pkt.getBit(pkt.A_BIT)) {
                GPacket gp = GPacket.getInstance();
                gp.setType(ProtocolGlobals.G_CLIENT_CLOSED_REPLY);
                gp.putProp("S", new Integer(ProtocolGlobals.G_SUCCESS));

                try {
                    c.unicast(sender, gp);
                }
                catch (IOException e) {}
            }
        }
        else if (pkt.getType() == ProtocolGlobals.G_CLIENT_CLOSED_REPLY) {
            logger.log(logger.DEBUG,
                "MessageBus: Received G_CLIENT_CLOSED_REPLY from " +
                "{0} : STATUS = {1}",
                sender, ((Integer) pkt.getProp("S")));
        }
        else {
            logger.log(logger.WARNING, "ClientClosedHandler " +
                "Internal error : Cannot handle this packet :" +
                pkt.toLongString());
        }
    }
}


/*
 * EOF
 */
