/*
 * @(#)LogMonitor.java	1.3 02/13/06
 *
 * Copyright 2006 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.management.mbeans;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.AttributeChangeNotification;

import com.sun.messaging.jms.management.server.*;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;

public class LogMonitor extends MQMBeanReadOnly  {
    private static String[] logNotificationTypes = {
		    LogNotification.LOG_LEVEL_PREFIX + LogLevel.WARNING,
		    LogNotification.LOG_LEVEL_PREFIX + LogLevel.ERROR,
		    LogNotification.LOG_LEVEL_PREFIX + LogLevel.INFO
		};

    private static MBeanNotificationInfo[] notifs = {
	    new MBeanNotificationInfo(
		    logNotificationTypes,
		    LogNotification.class.getName(),
	            mbr.getString(mbr.I_LOG_NOTIFICATIONS)
		    )
		};

    public LogMonitor()  {
	super();
    }

    public String getMBeanName()  {
	return ("LogMonitor");
    }

    public String getMBeanDescription()  {
	return (mbr.getString(mbr.I_LOG_MON_DESC));
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo()  {
	return (null);
    }

    public MBeanOperationInfo[] getMBeanOperationInfo()  {
	return (null);
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo()  {
	return (notifs);
    }

    public void notifyLogMessage(String level, String msg)  {
	LogNotification n;
	n = new LogNotification(LogNotification.LOG_LEVEL_PREFIX + level, 
			this, sequenceNumber++);

	n.setMessage(msg);
	n.setLevel(level);

	sendNotification(n);
    }
}
