/*
 * @(#)LicenseManager.java	1.1 03/20/03
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.license;

import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.util.log.Logger;

import java.io.*;
import java.util.*;

/**
 * Represents a broker license.
 */
public class LicenseManager {
    private static BrokerResources br = Globals.getBrokerResources();
    private static Logger logger = Globals.getLogger();

    /** Cache the current license object */
    private LicenseBase currentLicense = null;

    public LicenseManager() {}

    /**
     * This method loads the appropriate license.
     */
    public LicenseBase getLicense(String filestr) throws BrokerException {
        if (currentLicense != null)
            return currentLicense;

        // Step 1 : Choose the best LicenseBase implementation class.
        LicenseBase base = getLicenseBase();
        if (base == null) {
            // No license base class in the package!
            // This should never happen. No I18N necessary.
            throw new BrokerException(
                "Could not find license base class." +
                "This is a broker packaging error.");
        }

        currentLicense = base;
        return base;
    }

    private LicenseBase getLicenseBase() throws BrokerException {
        return new RILicense();
    }

    /**
     * Load all valid licenses from from the license directory.
     * @return an array of License objects
     */
    public static LicenseBase[] loadFileLicenses() {
        return new LicenseBase[0];
    }
}

/*
 * EOF
 */
