/*
 * @(#)TransactionUID.java	1.1 11/29/05
 *
 * Copyright 2001 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.migration;

import java.io.*;
import com.sun.messaging.jmq.util.UID;


/**
 * Transaction Unique Identifier. A globally unique identifier for
 * a transaction. 
 *
 * Object format prior to 370 filestore, use for migration purpose only.
 * @see com.sun.messaging.jmq.jmsserver.data.TransactionUID
 */
public class TransactionUID extends com.sun.messaging.jmq.util.UID {

    // compatibility w/ 3.01, 3.5, 3.6
    static final long serialVersionUID = 3158474602500727000L;

    public TransactionUID() {
        // Allocates a new id
        super();
    }

    public TransactionUID(long id) {
        // Wraps an existing id
        super(id);
    }

    public String toString() {
        return super.toString();
    }

    public Object readResolve() throws ObjectStreamException {
        // Replace w/ the new object
        Object obj = new com.sun.messaging.jmq.jmsserver.data.TransactionUID(id);
        return obj;
    }
}
