/*
 * @(#)TransactionAcknowledgement.java	1.1 11/29/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.migration;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.*;
import java.io.*;

/**
 * Acknowledgement for transactions. 
 *
 * Object format prior to 370 filestore, use for migration purpose only.
 * @see com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement
 */
public class TransactionAcknowledgement implements Serializable
{
    // compatibility w/ 3.0.1
    static final long serialVersionUID = 1518763750089861353L;

    private static Logger logger = Globals.getLogger();

    SysMessageID sysid = null;
    ConsumerUID iid = null;

    // sid is the stored UID associated w/ the ack
    // at this point, we really just want the stored uid
    // BUT in the future we may want the original UID
    // Since we kept iid in the past, we still keep it
    // for support
    ConsumerUID sid = null;

    // default construct for uninitialized object
    public TransactionAcknowledgement() {
    }

    /**
     * Construct the acknowledgement with the specified sysid and iid.
     * @param sysid	message system id
     * @param iid	interest id
     */
    public TransactionAcknowledgement(SysMessageID sysid, ConsumerUID iid,
            ConsumerUID sid) {
        this.sysid = sysid;
        this.iid = iid;
        this.sid = sid;
    }

    /**
     * @return the interest id
     */
    public ConsumerUID getConsumerUID() {
        return iid;
    }

    /**
     * @return the stored interest id
     */
    public ConsumerUID getStoredConsumerUID() {
        return sid;
    }

    /**
     * @return the message system id
     */
    public SysMessageID getSysMessageID() {
	return sysid;
    }

    /**
     * Returns a hash code value for this object.
     * ?? just added the hashCode of sysid and iid together ??
     */
    public int hashCode() {
	return sysid.hashCode() + iid.hashCode();
    }

    // just compare the hashcode
    public boolean equals(Object o) {
	if ((o instanceof TransactionAcknowledgement) &&
	    (hashCode() == o.hashCode())) {
	    return true;
	} else {
	    return false;
	}
    }

    public String toString() {
	return "[" + sysid.toString() + "]" + iid.toString() + ":"
             + sid.toString();
    }

    // for serializing the object
    private void writeObject(ObjectOutputStream s) throws IOException {
	sysid.writeID(new DataOutputStream(s));
	s.writeObject(iid);
	s.writeObject(sid);
    }

    // for serializing the object
    private void readObject(ObjectInputStream s)
	throws IOException, ClassNotFoundException {

	sysid = new SysMessageID();
	sysid.readID(new DataInputStream(s));
	iid = (ConsumerUID)s.readObject();
        try {
	    sid = (ConsumerUID)s.readObject();
        } catch (Exception ex) { // deal w/ missing field in 3.0.1
            logger.log(Logger.DEBUG,"ReadObject: old transaction format");
            sid = iid;
        }
    }

    public Object readResolve() throws ObjectStreamException {
        // Replace w/ the new object
        Object obj = new 
            com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement(
                sysid, iid, sid);
        return obj;
    }
}
