/*
 * @(#)GetDurablesHandler.java	1.13 04/03/03
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import java.util.Iterator;
import java.util.Set;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.admin.DurableInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;

public class GetDurablesHandler extends AdminCmdHandler
{
    public GetDurablesHandler(AdminDataHandler parent) {
	super(parent);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                 cmd_props);
        }
	String destination = (String)cmd_props.get(MessageType.JMQ_DESTINATION);

	// Send reply
	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);
        int status = Status.OK;

        Vector v = null;
        String err = null;
        if (destination == null)  {
            v = new Vector();
            err = "Null destination passed to GetDurablesHandler";
            status = Status.ERROR;
        } else {
            DestinationUID duid= DestinationUID.getUID(
                     destination, false);

            Set s = Subscription.getAllSubscriptions(duid);

            v = new Vector();

            Iterator itr = s.iterator();
            while (itr.hasNext()) {
                Subscription sub = (Subscription)itr.next();
                DurableInfo di = new DurableInfo();
                di.name = sub.getDurableName();
                di.clientID = sub.getClientID();
                di.isActive = sub.isActive();
                di.nMessages = sub.size();
                v.add(di);
            }

        }     

	setProperties(reply, MessageType.GET_DURABLES_REPLY,
		status, err);

	setBodyObject(reply, v);
	parent.sendReply(con, cmd_msg, reply);
    return true;
    }
}
