/*
 * @(#)DestroyDestinationHandler.java	1.25 10/17/05
 *
 * Copyright 2000-2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import java.util.Hashtable;
import java.io.IOException;
import java.io.*;
import java.util.Vector;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.util.admin.MessageType;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.jmsserver.core.Destination;

//XXX:Audit:Removed
//import com.sun.messaging.jmq.jmsserver.audit.MQAuditSession;

public class DestroyDestinationHandler extends AdminCmdHandler
{
    public DestroyDestinationHandler(AdminDataHandler parent) {
	super(parent);
    }

    /**
     * Handle the incomming administration message.
     *
     * @param con	The Connection the message came in on.
     * @param cmd_msg	The administration message
     * @param cmd_props The properties from the administration message
     */
    public boolean handle(IMQConnection con, Packet cmd_msg,
				       Hashtable cmd_props) {

	if ( DEBUG ) {
            logger.log(Logger.DEBUG, this.getClass().getName() + ": " +
                "Destroying destination: " + cmd_props);
        }

	String destination = (String)cmd_props.get(MessageType.JMQ_DESTINATION);
	Integer destType = (Integer)cmd_props.get(MessageType.JMQ_DEST_TYPE);

        int status = Status.OK;
        String errMsg = null;

        try {

            if (destType == null) {
                throw new Exception(rb.X_NO_DEST_TYPE_SET);
            }

//XXX:Audit:Removed
//	    // audit logging for destroy destination
//	    Globals.getAuditSession().destinationOperation(
//			con.getUserName(), con.remoteHostString(),
//			MQAuditSession.DESTROY_DESTINATION,
//			DestType.isQueue(destType.intValue())?
//				MQAuditSession.QUEUE:MQAuditSession.TOPIC,
//			destination);


            boolean ok = (Destination.removeDestination(destination,
                DestType.isQueue(destType.intValue()),
                rb.getString(rb.M_ADMIN_REQUEST))) != null;

            if (!ok) {
                status = Status.ERROR;
                String subError = rb.getString(rb.E_NO_SUCH_DESTINATION,
                        DestType.toString(destType.intValue()), destination);
                errMsg = rb.getString( rb.X_DESTROY_DEST_EXCEPTION, 
                            destination, subError);

            }
        } catch (Exception ex) {
            status = Status.ERROR;
            errMsg = rb.getString( rb.X_DESTROY_DEST_EXCEPTION, 
                            destination, getMessageFromException(ex));
            if (ex instanceof com.sun.messaging.jmq.jmsserver.util.BrokerException)
                logger.log(Logger.WARNING, rb.X_DESTROY_DEST_EXCEPTION,
                          destination, "",ex);
            else
                logger.logStack(Logger.WARNING, rb.X_DESTROY_DEST_EXCEPTION,
                          destination, "",ex);

        }

	// Send reply
	Packet reply = new Packet(con.useDirectBuffers());
	reply.setPacketType(PacketType.OBJECT_MESSAGE);

	setProperties(reply, MessageType.DESTROY_DESTINATION_REPLY,
		status, errMsg);

	parent.sendReply(con, cmd_msg, reply);
    return true;
    }
}
