/*
 * @(#)VerifyTransactionHandler.java	1.9 12/14/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers;

import java.util.*;
import java.io.*;
import com.sun.messaging.jmq.jmsserver.data.*;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;


/**
 * Handler class which deals with starting/stoping the delivery of 
 * messages to a specific connection
 */
public class VerifyTransactionHandler extends PacketHandler 
{

    private Logger logger = Globals.getLogger();
    public static boolean DEBUG = false;
    TransactionList translist = null;
  

    public VerifyTransactionHandler(TransactionList list) {
         this.translist = list;
   }

    /**
     * Method to handle Destination (create or delete) messages
     */
    public boolean handle(IMQConnection con, Packet msg) 
        throws BrokerException
    {

        int status = Status.OK;
        String reason = null;

        assert msg.getPacketType() == PacketType.VERIFY_TRANSACTION;

        Packet pkt = new Packet(con.useDirectBuffers());
        pkt.setConsumerID(msg.getConsumerID());

        pkt.setPacketType(PacketType.VERIFY_TRANSACTION_REPLY);

        Hashtable hash = new Hashtable();

        Hashtable props = null;
        TransactionUID tuid = null;
        try {
            props = msg.getProperties();
            Long ttid = (Long)props.get("JMQTransactionID");
            long id = (ttid == null ? 0 : ttid.longValue());
            if (id == 0) {
                throw new BrokerException("Bad/Missing transaction id");
            }

            tuid = new TransactionUID(id);

            TransactionState ts = translist.retrieveState(tuid);
            if (ts == null) {
                status = Status.GONE;
            } else {
                int realstate = ts.getState();

                if (realstate != TransactionState.PREPARED) {
                    // LKS - XXX
                    // for now return GONE because it seems to work
                    // better for the client - revisit
     
                    throw new BrokerException("Transaction " + tuid + 
                        " is not PREPARED " + ts, Status.GONE);
                }
                Hashtable m = translist.getTransactionMap(tuid, true);

                // write it to the body
                if (m != null) {
                    try {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        ObjectOutputStream oos = new ObjectOutputStream(bos);
                        oos.writeObject(m);
                        oos.flush();
                        bos.flush();
                        pkt.setMessageBody(bos.toByteArray());
                        bos.close();
                    } catch (Exception ex) {
                         logger.log(Logger.WARNING,
                              BrokerResources.E_INTERNAL_BROKER_ERROR,
                              " sending back broker data", ex);
                    }
                }
            }
        } catch (BrokerException ex) {
            reason = ex.getMessage();
            status = ex.getStatusCode();
            if (status != Status.GONE && status != Status.NOT_FOUND)
            {
                logger.logStack(Logger.INFO,
                      BrokerResources.E_INTERNAL_BROKER_ERROR,
                     "unknown status", ex);
            } else {
                logger.log(Logger.DEBUG,"Transaction " + tuid 
                       + " not found", ex);
            }
        } catch (Throwable ex) {
            logger.logStack(Logger.INFO,
                      BrokerResources.E_INTERNAL_BROKER_ERROR,
                     "exception processing verify transaction ", ex);
            reason = ex.toString();
            status = Status.ERROR;
        }

        if (status == Status.GONE) { // convert to NF
            status = Status.NOT_FOUND;
        }    

        hash.put("JMQStatus", new Integer(status));
        if (reason != null)
            hash.put("JMQReason", reason);
        if (con.DUMP_PACKET || con.OUT_DUMP_PACKET)
            hash.put("JMQReqID", msg.getSysMessageID().toString());

        pkt.setProperties(hash);
        con.sendControlMessage(pkt);
        return true;
    }

}
