/*
 * @(#)SessionHandler.java	1.15 03/25/05
 *
 * Copyright 2000-2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data.handlers;

import java.util.*;
import java.io.*;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.util.PacketUtil;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;



public class SessionHandler extends PacketHandler 
{
    private Logger logger = Globals.getLogger();
    public static boolean DEBUG = false;
  

    public SessionHandler() {
    }

    /**
     * Method to handle Session(add or delete) messages
     */
    public boolean handle(IMQConnection con, Packet msg) 
        throws BrokerException
    {
        int status = Status.OK;
        String reason = null;
        Hashtable hash = new Hashtable(); // return props
        boolean isIndemp = msg.getIndempontent();

        try {
            Hashtable props = msg.getProperties();

            Session session = null;
            if (msg.getPacketType() == PacketType.CREATE_SESSION) {
               Integer  ack = (props == null ? null : 
                    (Integer)props.get("JMQAckMode"));
               // if we dont know, treat like client ack
               int stype = (ack == null ? Session.NONE
                      : ack.intValue());

               if (isIndemp) {
                   session = Session.getSession(
                        (SysMessageID)msg.getSysMessageID());
               }
               if (session == null) {
                   session = Session.createSession(con.getConnectionUID(),
                        (SysMessageID)msg.getSysMessageID().clone());
                   session.setAckType(stype);
                   con.attachSession(session);
               }
               hash.put("JMQSessionID", new Long(
                    session.getSessionUID().longValue()));

            } else {
                assert msg.getPacketType() == PacketType.DESTROY_SESSION;
                Long lsessionid = (Long)props.get("JMQSessionID");
                if (lsessionid == null) {
                    throw new BrokerException(
                        Globals.getBrokerResources().getString(
                             BrokerResources.X_INTERNAL_EXCEPTION,
                             "protocol error, no session"));
                }
                SessionUID sessionID = new SessionUID(
                       lsessionid.longValue());

                 if (!isIndemp || Session.getSession(sessionID) != null) {
                     assert con.getSession(sessionID) != null;

                     Session.closeSession(sessionID);
                     con.closeSession(sessionID);
                 }
                
            }
        } catch (Exception ex) {
            boolean log = false;
            reason = ex.getMessage();
            if (ex instanceof BrokerException) {
                status = ((BrokerException)ex).getStatusCode();
                log = false;
            } else {
                status = Status.ERROR;
                log = true;
            }

            if (log) {
                logger.logStack(Logger.INFO,
                   Globals.getBrokerResources().getString(
                      BrokerResources.X_INTERNAL_EXCEPTION,
                        " session "),ex);
            } else {
                logger.log(Logger.INFO, ex.getMessage());
            }
        }
            
        hash.put("JMQStatus", new Integer(status));
        if (reason != null)
            hash.put("JMQReason", reason);

        if (msg.getSendAcknowledge()) {
            Packet pkt = new Packet(con.useDirectBuffers());
            pkt.setConsumerID(msg.getConsumerID()); // correlation ID
            pkt.setPacketType(msg.getPacketType()+1);
            pkt.setProperties(hash);
            con.sendControlMessage(pkt);
        }

        return true;


    }


}
