/*
 * @(#)Destination.java	1.45 05/06/03
 *
 * Copyright 2000-2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */


package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;

import java.util.*;
import java.io.*;
import java.lang.*;

/**
 * This class represents a destination (topic or queue name)
 *
 * @deprecated since 3.5
 * @see com.sun.messaging.jmq.jmsserver.core.Destination
 *
 */
public class Destination implements java.io.Serializable
{
    static final long serialVersionUID = -5305744890489268213L;

    private String name = null;
    protected int type = -1;
    protected ConnectionUID id = null;
    private boolean autocreate = false;
    protected SizeString msgSizeLimit = null;
    protected int countLimit = 0;
    protected SizeString memoryLimit = null;

    protected String dest_string = null;
    protected String unique_id = null;

    public Object readResolve() throws ObjectStreamException {
        try {
            com.sun.messaging.jmq.jmsserver.core.Destination 
                 obj = com.sun.messaging.jmq.jmsserver.
                    core.Destination.createDestination(name, type,
                       false, autocreate, id);
            obj.setMaxByteSize(msgSizeLimit);
            if (countLimit > 0)
                obj.setCapacity(countLimit);
            if (memoryLimit != null && memoryLimit.getBytes() > 0)
                obj.setByteCapacity(memoryLimit);
            obj.initializeOldDestination();
            return obj;
        } catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }

    } 

}
