/*
 * @(#)TransactionProcessing.java	1.2 09/20/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 */

package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.CacheHashMap;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.util.log.Logger;

/**
 * This class handled transaction processing and requeing
 */

//
// NOTE: 
// ultimately, all txn processing should be moved to this file
// however it is too close to the beta freeze for me to do that
// it will be looked after beta or in the next release
//
public class TransactionProcessing
{
    TransactionList translist = Globals.getTransactionList();
    Logger logger = Globals.getLogger();


    public void checkState(BrokerAddress bkr)
    {
        // checks all indoubt transactions
    }

    public void addRemoteTxn(BrokerAddress bkr, TransactionUID txnid)
    {
    }

    public void removeRemoteTxn(BrokerAddress bkr, TransactionUID txnid)
    {
    }

    public void checkLocalTransaction(TransactionUID txnid)
    {
        // ok if its not prepared, rollback
        // if its rolledback ... clean up all local acks
        // if its committed .. clean up all local messages
        // see if we can remote the txn -> must have no
        // txnids and no messages
        // if not start to watch it
    }

    public void handleLocalRollback(TransactionUID txnid)
    {
        // call doCommit for now
    }

    public void handleLocalCommit(TransactionUID txnid)
    {
        // call doRollback for now
    }

    public void handleRemoteRollback(TransactionUID txnid)
    {
        // logic from MultibrokerRouter
    }

    public void handleRemoteCommit(TransactionUID txnid)
    {
        // logic from MultibrokerRouter
    }

    public boolean watchLocalTransaction(TransactionUID txnid)
    {
        // wake up and see if the txn is complete
        // return true if it is, false otherwise
        return false;
    }

    public void checkRemoteTransaction(TransactionUID txnid)
        throws BrokerException
    {
        // if not in list, throw GONE
        TransactionState ts = translist.retrieveState(txnid);
        if (ts == null) {
            throw new BrokerException(
                 BrokerResources.E_INTERNAL_BROKER_ERROR,
		"Unknown TXN", null,
                 Status.GONE);
        }

        // ok if rolled back, handle it differently
        // depending whether its local or remote

    }



}
