/*
 * @(#)TransactionID.java	1.7 04/02/01
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data;

import java.io.*;


public class TransactionID implements Serializable
{
    private int port = 0;
    private byte[] IP = null;
    private int transid = 0;
    private String unique_id = null;

    public TransactionID(int transid, byte[] IP, int port)
    {
        this.port = port;
        this.IP = IP;
        this.transid = transid;
    }

    private void initUniqueStr() {

        unique_id = "";
        
        for (int i = 0; i < IP.length; i ++) {
            unique_id +=Integer.toHexString(((int)IP[i]) & 0xff);
        }
        unique_id += ":" + Integer.toHexString(port) + ":" + Integer.toHexString(transid);
    }

    public boolean equals(Object obj)
    {
        if (! (obj instanceof TransactionID)) 
            return false;

        TransactionID tid = (TransactionID) obj;

        if (port != tid.port || transid != tid.transid) {
            return false;
        }

        if ((IP == null || tid.IP == null) && IP != tid.IP ) 
            return false;

        if (IP.length != tid.IP.length)
            return false;

        for (int i =0; i < IP.length; i ++)
            if (IP[i] != tid.IP[i])
                return false;
        return true;
    }

    public int hashCode() {
        int h = 0;
        for (int i =0; i < IP.length; i ++)
            h += (new Byte(IP[i])).intValue();

        h = 31*h + port;
        h = 31*h + transid;

        return h;
    }

    public String toString() {
/*
        return "TransactionID[" + transid + "," +
                 (new String(IP)) + "," + port + "]";
*/
        return "TransactionID[" + transid + "," +
                  port + "]";
    }

    public String getUniqueName() {
        if (unique_id == null) {
            initUniqueStr();
        }
        return unique_id;

    }

}
