/*
 * @(#)ErrHandler.java	1.8 01/28/04
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.*;
import com.sun.messaging.jmq.jmsserver.service.*;
import com.sun.messaging.jmq.jmsserver.service.imq.*;
import com.sun.messaging.jmq.jmsserver.util.*;
/**
 * abstract class for classes which deal with handling specific
 * message types
 */
public abstract class ErrHandler  extends PacketHandler
{
   // XXX REVISIT 1/25/00 racer
   // these should really be part of the error or debug
   // information

   public static final int INFORMATION = 0;
   public static final int WARNING = 1;
   public static final int ERROR = 2;
   public static final int FATAL = 3;

    /**
     * method to handle processing the specific packet associated
     * with this PacketHandler
     */
    public abstract void sendError(IMQConnection con, int level, String msg, Packet pkt);
    public abstract void sendError(IMQConnection con, BrokerException ex, Packet pkt);



}
