/*
 * @(#)DefaultHandler.java	1.17 01/28/04
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.data;

import java.util.Hashtable;

import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.resources.*;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.Status;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.Logger;


/**
 * Handler class which deals with handling unexpected messages
 */
public class DefaultHandler extends ErrHandler 
{
    Logger logger = Globals.getLogger();

    public static boolean DEBUG = false;

    public void sendError(IMQConnection con, int level, String msg, Packet pkt) {
        // XXX REVISIT 3/7/00 racer
        // add code to return ERROR message
        // also log message
        logger.log(Logger.ERROR, msg);
        // send the reply
        sendError(con, pkt);

    }
    public void sendError(IMQConnection con, BrokerException ex, Packet pkt) {
        // XXX REVISIT 3/7/00 racer
        // add code to return ERROR message
        // also log message

        logger.logStack(Logger.ERROR,BrokerResources.E_INTERNAL_BROKER_ERROR, "Uncaught Exception", ex);
        // send the reply
        sendError(con, pkt);
   }

   // if we get an uncaught exception, we want to make sure
   // that the reply (if any) is sent back to the consumer
   // so it doesnt hang because of a broker error or because
   // the client sent bad protocol
   private void sendError(IMQConnection con, Packet msg) {
       if (msg.getSendAcknowledge()) {
            Packet pkt = new Packet(con.useDirectBuffers());
            pkt.setPacketType(msg.getPacketType() + 1);
            pkt.setConsumerID(msg.getConsumerID());
            Hashtable hash = new Hashtable();
            hash.put("JMQStatus", new Integer(Status.ERROR));
            pkt.setProperties(hash);
            con.sendControlMessage(pkt);
       }
   }

    /**
     * Method to handle messages we don't recognize. If the message
     * has the 'A' bit set then the client is expecting a reply.
     * By convetion reply packet types are the request packet type + 1.
     */
    public boolean handle(IMQConnection con, Packet msg) throws
            BrokerException
    {
	// Check if A bit is set
	if (msg.getSendAcknowledge()) {
            // 'A' bit is set. Send a NOT_IMPLEMENTED reply
            if (DEBUG) {
                logger.log(Logger.DEBUG,
                    "DefaultHandler: replying to unknown packet type: " +
                    msg.getPacketType());
            }
            Packet pkt = new Packet(con.useDirectBuffers());
            pkt.setPacketType(msg.getPacketType() + 1);
            pkt.setConsumerID(msg.getConsumerID());
            Hashtable hash = new Hashtable();
            hash.put("JMQStatus", new Integer(Status.NOT_IMPLEMENTED));
            pkt.setProperties(hash);
            con.sendControlMessage(pkt);
	} else {
            // No 'A' bit. Silently ignore
            if (DEBUG) {
                logger.log(Logger.DEBUG,
                    "DefaultHandler: ignoring unknown packet type : " +
                    msg.getPacketType());
            }
        }
        return true;
    }

}
