/*
 * @(#)ConsumerUID.java	1.1 11/30/05
 *
 * Copyright 2001-2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.core.migration;

import com.sun.messaging.jmq.util.*;
import java.io.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Session;

/**
 * Object format prior to 370 filestore, use for migration purpose only.
 * @see com.sun.messaging.jmq.jmsserver.core.ConsumerUID
 */
public class ConsumerUID extends com.sun.messaging.jmq.util.UID {

    static final long serialVersionUID = 5231476734057401743L;

    protected transient int ackType=Session.NONE;

    protected transient ConnectionUID conuid = null;
    protected transient BrokerAddress brokeraddr = Globals.getMyAddress();

    protected transient boolean shouldStore = false;

    public ConsumerUID() {
        // Allocates a new id
        super();
    }

    public ConsumerUID(long id) {
        // Wraps an existing id
        super(id);
    }

    public ConsumerUID(boolean empty) {
         super(0);
         if (!empty)
             initializeID();
    }

    /**
     * @deprecated since 3.5
     * for compatibility
     */
    public ConsumerUID(int oldnum) {
         super(oldnum);
    }

    public boolean shouldStore() {
        return shouldStore;
    }

    public void setShouldStore(boolean store) 
    {
        shouldStore = store;
    }

    public boolean isEmpty() {
        return id == 0;
    }

    public void initializeID() {
        if (id == 0)
            id = UniqueID.generateID(prefix);
    }

    public void clear() {
        id =0;
        conuid = null;
        brokeraddr = null;
        ackType =Session.NONE;
    }

    public void updateUID(ConsumerUID uid) {
        id = uid.id;
    }

    public void copy(ConsumerUID uid) {
        id = uid.id;
        conuid = uid.conuid;
        brokeraddr = uid.brokeraddr;
        ackType = uid.ackType;
    }


    public boolean isAutoAck() {
        return (ackType == Session.AUTO_ACKNOWLEDGE);
    }

    public String getAckMode(int mode) {
        switch(ackType) {
            case Session.AUTO_ACKNOWLEDGE:
                return "AUTO_ACKNOWLEDGE";
            case Session.DUPS_OK_ACKNOWLEDGE:
                return "DUPS_OK_ACKNOWLEDGE";
            case Session.CLIENT_ACKNOWLEDGE:
                return "CLIENT_ACKNOWLEDGE";
            case Session.NO_ACK_ACKNOWLEDGE :
                return "NO_ACK_ACKNOWLEDGE";
            default:
                return "NONE";
        }
    }

    public boolean isDupsOK() {
        return (ackType == Session.DUPS_OK_ACKNOWLEDGE);
    }

    public boolean isNoAck() {
        return (ackType == Session.NO_ACK_ACKNOWLEDGE);
    }

    public boolean isUnsafeAck() {
        return isDupsOK() || isNoAck();
    }

    public void setAckType(int mode) {
        this.ackType = mode;
    }

    public void setConnectionUID(ConnectionUID cid) {
        this.conuid = cid;
    }
    public ConnectionUID getConnectionUID() {
        return conuid;
    }
    public void setBrokerAddress(BrokerAddress bkraddr) {
        this.brokeraddr = bkraddr;
    }
    public BrokerAddress getBrokerAddress() {
        if (brokeraddr == null)
            brokeraddr = Globals.getMyAddress();
        return this.brokeraddr;
    }

    public String toString() {
        return "[consumer:" + super.toString() + ", type="
                 + getAckMode(ackType) +"]";
    }

    public Object readResolve() throws ObjectStreamException {
        // Replace w/ the new object
        Object obj = new com.sun.messaging.jmq.jmsserver.core.ConsumerUID(id);
        return obj;
    }
}
