/*
 * @(#)ClusterBroadcaster.java	1.5 09/21/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.core.cluster;

import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import java.util.Map;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.core.*;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.io.SysMessageID;
import java.lang.reflect.*;


/**
 * Hides access to the clustering interface.
 */
public class ClusterBroadcaster implements ClusterBroadcast {

    ClusterBroadcast child = null;

    public ClusterBroadcaster(Integer maxBrokers, Integer clusterversion) 
        throws ClassNotFoundException, NoSuchMethodException, 
               InstantiationException, IllegalAccessException,
               InvocationTargetException, BrokerException
    {
        this(maxBrokers.intValue(), clusterversion.intValue());
    }

    public ClusterBroadcaster(int maxBrokers, int clusterversion) 
        throws ClassNotFoundException, NoSuchMethodException, 
               InstantiationException, IllegalAccessException,
               InvocationTargetException, BrokerException
    {
        try {

        Class c = Class.forName("com.sun.messaging.jmq.jmsserver"
                      + ".multibroker.ClusterBroadcaster");
        Class[] paramTypes = { Integer.class, Integer.class };
        Constructor cons = c.getConstructor(paramTypes);
        Object[] paramArgs = { new Integer(maxBrokers), 
                        new Integer(clusterversion) };
        child = (ClusterBroadcast)cons.newInstance(paramArgs);

        } catch (InvocationTargetException e) {
        Globals.getLogger().logStack(Logger.ERROR, 
          Globals.getBrokerResources().getKString(
		  BrokerResources.E_INTERNAL_BROKER_ERROR, e.getMessage()), e);
        Globals.getLogger().logStack(Logger.ERROR, 
          e.getTargetException().getMessage(), e.getTargetException()); 
        throw e;
        }
    
    }

    public Protocol getProtocol()
    {
        return child.getProtocol();
    }

    public boolean waitForConfigSync() {
        return child.waitForConfigSync();
    }

    public void setMatchProps(Properties match) {
        child.setMatchProps(match);
    }

    public int getClusterVersion() {
        return child.getClusterVersion();
    }

    public void startClusterIO() {
        child.startClusterIO();
    }

    public void stopClusterIO(boolean requestTakeover)
    {
        child.stopClusterIO(requestTakeover);
    }

    public void pauseMessageFlow() throws IOException
    {
        child.pauseMessageFlow();
    }

    public void resumeMessageFlow() throws IOException
    {
        child.resumeMessageFlow();
    }

    public void messageDelivered(SysMessageID id, ConsumerUID uid,
                BrokerAddress ba)
    {
        child.messageDelivered(id, uid, ba);
    }

    public void forwardMessage(PacketReference ref, Collection consumers)
    {
        child.forwardMessage(ref, consumers); // XXX - use broker consumers
    }

    /**
     * Returns the address of this broker.
     * @return <code> BrokerAddress </code> object representing this
     * broker.
     */
    public BrokerAddress getMyAddress()
    {
        return child.getMyAddress();
    }

    public boolean lockSharedResource(String resource, Object owner)
    {
         return child.lockSharedResource(resource, owner);
    }

    public boolean lockDestination(DestinationUID uid, Object owner)
    {
        return child.lockDestination(uid, owner);

    }

    public void unlockDestination(DestinationUID uid, Object owner)
    {
        child.unlockDestination(uid, owner);
    }

    public boolean lockClientID(String clientid, Object owner, boolean shared)
    {
        return child.lockClientID(clientid, owner, shared);
    }

    public void unlockClientID(String clientid, Object owner)
    {
        child.unlockClientID(clientid, owner);
    }

    public boolean getConsumerLock(ConsumerUID uid,
                    DestinationUID duid, int position,
                    int maxActive, Object owner)
            throws BrokerException
    {
        return child.getConsumerLock(uid, duid, position,
                   maxActive, owner);
    }

    public void unlockConsumer(ConsumerUID uid, DestinationUID duid, int position)
    {
        child.unlockConsumer(uid, duid, position);
    }
    
    public void acknowledgeMessage(BrokerAddress address, SysMessageID mid, 
                                   ConsumerUID cid, int ackType, boolean ackack,
                                   Map optionalProps, Long txnID)
                                   throws BrokerException
    {
        child.acknowledgeMessage(address, mid, cid, ackType, ackack, optionalProps, txnID);
    }

    public void recordUpdateDestination(Destination d)
        throws BrokerException
    {
        child.recordUpdateDestination(d);
    }

    public void recordRemoveDestination(Destination d)
        throws BrokerException
    {
         child.recordRemoveDestination(d);
    }

    public void createDestination(Destination dest)
            throws BrokerException
    {
         child.createDestination(dest);
    }

    public void recordCreateSubscription(Subscription sub)
        throws BrokerException
    {
        child.recordCreateSubscription(sub);
    }

    public void recordUnsubscribe(Subscription sub)
        throws BrokerException
    {
         child.recordUnsubscribe(sub);
    }

    public void createSubscription(Subscription sub, Consumer cons)
            throws BrokerException
    {
        child.createSubscription(sub, cons);
    }

    public void createConsumer(Consumer con)
            throws BrokerException
    {
        child.createConsumer(con);
    }

    public void updateDestination(Destination dest)
            throws BrokerException
    {
        child.updateDestination(dest);
    }

    public void updateSubscription(Subscription sub)
            throws BrokerException
    {
        child.updateSubscription(sub);
    }

    public void updateConsumer(Consumer con)
            throws BrokerException
    {
        child.updateConsumer(con);
    }


    public void destroyDestination(Destination dest)
            throws BrokerException
    {
        child.destroyDestination(dest);
    }

    public void destroySubscription(Subscription sub)
            throws BrokerException
    { 
        child.destroySubscription(sub);
    }

    public void destroyConsumer(Consumer con)
            throws BrokerException
    {
        child.destroyConsumer(con);
    }

    public void connectionClosed(ConnectionUID uid, boolean admin)
    {
        child.connectionClosed(uid, admin);
    }

    public void reloadCluster()
    {
        child.reloadCluster();
    }

    /**
     * Ensures that the given "prefix" number is unique in the
     * cluster. This method is used to ensure the uniqueness of the
     * UIDs generated by a broker.
     *
     * @return true if the number is unique. false if some other
     * broker is using this number as a UID prefix.
     */
    public boolean lockUIDPrefix(short p)
    {
        return child.lockUIDPrefix(p);
    }
}

