/*
 * @(#)BrokerMQAddress.java	1.2 04/12/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.*;
import java.net.*;

public class BrokerMQAddress extends MQAddress
{
    private transient InetAddress host = null;
    private transient String tostring = null;

    protected BrokerMQAddress() {} 

    protected void initialize(String addr) 
        throws MalformedURLException
    {
        super.initialize(addr);
        serviceName = "";
    }

    public boolean equals(Object obj) {
        if (! (obj instanceof BrokerMQAddress)) return false;

        return toString().equals(((BrokerMQAddress)obj).toString());
    }

    public int hashCode() { 
        return toString().hashCode();
    }

    public String toString() {
        if (tostring != null) return tostring;

        if (getIsHTTP()) return super.toString();  

        tostring = getSchemeName() + "://" + host.getHostAddress() + ":" + port + "/" + getServiceName();
        return tostring;
 
    }

    public InetAddress getHost() { 
        return host;
    }


    public void resolveHostName() throws UnknownHostException {
        if (host == null) {
            String h = getHostName();
            if (h == null || h.equals("") || h.equals("localhost")) {
                host = InetAddress.getLocalHost();
            } else {
                host = InetAddress.getByName(h);
            }
        }
    }

    /**
     * Parses the given MQ Message Service Address and creates an
     * MQAddress object.
     */
    public static BrokerMQAddress createAddress(String addr)
        throws MalformedURLException, UnknownHostException {
        BrokerMQAddress ret = new BrokerMQAddress();
        ret.initialize(addr);
        ret.resolveHostName();
        return ret;
    }

}
