
/*
 * @(#)ConfigListener.java	1.4 09/22/00
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver.config;


/**
 * This interface is used by any object who needs to listen
 * for notification when a specific property has changed.<P>
 *
 */
public interface ConfigListener 
{
    /**
     * method which is called to validate that the passed in
     * name/value is valid.
     *
     * If the data is not valid, a PropertyUpdateException should be
     * thrown.
     *
     * @param name the name of the property to be validated
     * @param value the new value requested for that property
     * @throws PropertyUpdateException the the value is invalid
     *
     */
    public void validate(String name, String value)
        throws PropertyUpdateException;

    /**
     * method which is called then a class which is interested in
     * the state of a specific property should updated its internal
     * state based on the new value of the property.
     *
     * @param name the name of the property to be validated
     * @param value the new value requested for that property
     * @return true if the property has taken affect, false if it
     *        will not take affect until the next broker restart
     *
     */
    public boolean update(String name, String value);
}
