/*
 * @(#)UserPrinter.java	1.1 00/10/24
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.auth.usermgr;

import com.sun.messaging.jmq.util.MultiColumnPrinter;

/*
 * This class is for printing the user database in neat
 * collumns as in:
 * <PRE>
 *
 * --------------------------------------
 * User Name    Role         Active state
 * --------------------------------------
 * admin        admin        true
 * guest        anonymous    true
 *
 * </PRE>
 */
public class UserPrinter extends MultiColumnPrinter {

    public UserPrinter(int numCol, int gap, String border) {
	super(numCol, gap, border);
    }

    public UserPrinter(int numCol, int gap) {
	super(numCol, gap);
    }

    public void doPrint(String str) {
        Output.stdOutPrint(str);
    }

    public void doPrintln(String str) {
        Output.stdOutPrintln(str);
    }
}
