/*
 * @(#)UserMgrOptionParser.java	1.9 04/05/18
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsserver.auth.usermgr;

import java.util.Properties;
import javax.naming.*;
import com.sun.messaging.jmq.util.options.OptionDesc;
import com.sun.messaging.jmq.util.options.OptionParser;
import com.sun.messaging.jmq.util.options.OptionException;

/**
 * This class is a command line option parser that is
 * specific to jmqcmd.
 *
 * The options that are valid for jmqcmd are defined in
 * the options table. This class also defines a
 * parseArgs() method, which is different from
 *	OptionParser.parseArgs()
 * because it:
 * <UL>
 * <LI>returns a ObjMgrProperties object
 * <LI>only takes the String args[] as parameter
 * </UL>
 *
 * @version	1.9 04/05/18
 * @see		com.sun.messaging.jmq.admin.util.OptionType
 * @see		com.sun.messaging.jmq.admin.util.OptionDesc
 * @see		com.sun.messaging.jmq.admin.util.OptionParser
 * @author	Isa Hashim
 */
public class UserMgrOptionParser extends OptionParser
			implements UserMgrOptions  {

    /**
     * Options for the jmqobjmgr utility
     */
    static OptionDesc userMgrOptions[] = {
	/* 
	 *
	 * OptionDesc(String option, int type, String baseProp, String value)
	 */
	new OptionDesc(CMD_ADD, OPTION_VALUE_HARDCODED, 
			PROP_NAME_CMD, PROP_VALUE_CMD_ADD),
	new OptionDesc(CMD_DELETE, OPTION_VALUE_HARDCODED, 
			PROP_NAME_CMD, PROP_VALUE_CMD_DELETE),
	new OptionDesc(CMD_LIST, OPTION_VALUE_HARDCODED, 
			PROP_NAME_CMD, PROP_VALUE_CMD_LIST),
	new OptionDesc(CMD_UPDATE, OPTION_VALUE_HARDCODED, 
			PROP_NAME_CMD, PROP_VALUE_CMD_UPDATE),

	new OptionDesc(CMD_EXISTS, OPTION_VALUE_HARDCODED, 
			PROP_NAME_CMD, PROP_VALUE_CMD_EXISTS),
	new OptionDesc(CMD_GETGROUP, OPTION_VALUE_HARDCODED, 
			PROP_NAME_CMD, PROP_VALUE_CMD_GETGROUP),
	new OptionDesc(CMD_GETGROUPSIZE, OPTION_VALUE_HARDCODED, 
			PROP_NAME_CMD, PROP_VALUE_CMD_GETGROUPSIZE),

	new OptionDesc(OPTION_ACTIVE, OPTION_VALUE_NEXT_ARG, 
			PROP_NAME_OPTION_ACTIVE, null),
	new OptionDesc(OPTION_PASSWD, OPTION_VALUE_NEXT_ARG, 
			PROP_NAME_OPTION_PASSWD, null),
	new OptionDesc(OPTION_ROLE, OPTION_VALUE_NEXT_ARG, 
			PROP_NAME_OPTION_ROLE, null),
	new OptionDesc(OPTION_USERNAME, OPTION_VALUE_NEXT_ARG, 
			PROP_NAME_OPTION_USERNAME, null),
	new OptionDesc(OPTION_INSTANCE, OPTION_VALUE_NEXT_ARG, 
			PROP_NAME_OPTION_INSTANCE, null),
	new OptionDesc(OPTION_PASSFILE, OPTION_VALUE_NEXT_ARG, 
			PROP_NAME_OPTION_PASSFILE, null),

	new OptionDesc(OPTION_FORCE, OPTION_VALUE_HARDCODED, 
			PROP_NAME_OPTION_FORCE, PROP_VALUE_OPTION_FORCE),
	new OptionDesc(OPTION_SILENTMODE, OPTION_VALUE_HARDCODED, 
			PROP_NAME_OPTION_SILENTMODE, PROP_VALUE_OPTION_SILENTMODE),

	/*
	 * These are options that are parsed by the startup script. They are
	 * parsed by the option parsing logic, but are not used to create
	 * the options property object.
	 */
	new OptionDesc("-javahome", OPTION_VALUE_NEXT_ARG,
		"", "", true),
	new OptionDesc("-jmqhome", OPTION_VALUE_NEXT_ARG,
		"", "", true),
	new OptionDesc("-jmqvarhome", OPTION_VALUE_NEXT_ARG,
		"", "", true),
	new OptionDesc("-varhome", OPTION_VALUE_NEXT_ARG,
		"", "", true),
	new OptionDesc("-verbose", OPTION_VALUE_HARDCODED,
		"", "", true),
	new OptionDesc("-jmqext", OPTION_VALUE_NEXT_ARG,
		"", "", true)
	};
    
    
    /**
     * Parses arg list using the specified option description
     * table and returns a ObjMgrProperties object which corresponds
     * to it.
     */
    public static UserMgrProperties parseArgs(String args[]) 
		throws OptionException  {
	UserMgrProperties userMgrProps = new UserMgrProperties();

	/*
	 * Invoke main parsing code in superclass
	 */
        parseArgs(args, userMgrOptions, userMgrProps); 

        return (userMgrProps); 
    }
}
