/*
 * @(#)TrustSSLSocketFactory.java	1.5 05/05/19
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.jmsserver.auth.ldap;

import javax.net.*;
import javax.net.ssl.*;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.Logger;

public abstract class TrustSSLSocketFactory extends javax.net.ssl.SSLSocketFactory {

    private Logger logger = Globals.getLogger();

    public static SocketFactory getDefault() {

        try {

        return getTrustSocketFactory();

        }
        catch (java.security.NoSuchAlgorithmException e) {
        Globals.getLogger().log(Logger.ERROR, e.getMessage(), e);
        }
        catch (java.security.KeyManagementException e) { 
        Globals.getLogger().log(Logger.ERROR, e.getMessage(), e);
        }

        return null;
    }

    private static SSLSocketFactory getTrustSocketFactory() 
                   throws java.security.NoSuchAlgorithmException,
                          java.security.KeyManagementException {

        SSLContext ctx = SSLContext.getInstance("TLS");
        TrustManager[] tm = new TrustManager[1];
        tm[0] = new X509TrustManager() {
                public void checkClientTrusted(java.security.cert.X509Certificate[] chain) {
                return;
                }
                public void checkClientTrusted(java.security.cert.X509Certificate[] chain, String type) {
                return;
                }
                public void checkServerTrusted(java.security.cert.X509Certificate[] chain) {
                return;
                }
                public void checkServerTrusted(java.security.cert.X509Certificate[] chain, String type) {
                return;
                }
                public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                return null;
                }
                };

        ctx.init(null, tm, null);
        return ctx.getSocketFactory();
    }
}
