/*
 * @(#)PermissionFactoryImpl.java	1.2 05/11/18
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.jmsserver.auth.acl;

import java.util.Map;
import com.sun.messaging.jmq.auth.jaas.*;

/**
 */

public class PermissionFactoryImpl implements PermissionFactory {

    public static boolean DEBUG = false;

    /**
     *
     */
    public java.security.Permission newPermission (String privateString, //can be null
                                                   String resourceName, 
                                                   String actions,
                                                   Map conditions) {
         
        if (resourceName.startsWith(PermissionFactory.CONN_RESOURCE_PREFIX)) {
            return new MQConnectionPermission(
                   resourceName.substring(PermissionFactory.CONN_RESOURCE_PREFIX.length()));
        }
        if (resourceName.startsWith(PermissionFactory.DEST_RESOURCE_PREFIX)) {
            return new MQDestinationPermission(
                   resourceName.substring(PermissionFactory.DEST_RESOURCE_PREFIX.length()),
                   actions);
        }
        if (resourceName.startsWith(PermissionFactory.AUTO_RESOURCE_PREFIX)) {
            return new MQAutoCreateDestPermission(
                   resourceName.substring(PermissionFactory.AUTO_RESOURCE_PREFIX.length()));
        }
        throw new IllegalArgumentException("invalid resource name " + resourceName);
    }

}
