/*
 * @(#)BrokerNotification.java	1.2 05/05/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsserver;

import java.util.*;



/**
 * Interface used for notification of broker changes
 */


public interface BrokerNotification
{
    /**
     * Shutdown of the broker has been requested through imqcmd
     */
    public static final int REASON_SHUTDOWN = 0;

    /**
     * Restart of the broker has been requested through imqcmd
     */
    public static final int REASON_RESTART = 1;

    /**
     * A fatal error of the broker has occured
     */
    public static final int REASON_FATAL = 2;

    /**
     * A serious (but non-fatal) error of the broker has occured
     */
    public static final int REASON_ERROR = 3;

    /**
     * An uncaught throwable has been thrown
     */
    public static final int REASON_EXCEPTION = 4;

    /**
     * BrokerProcess.stop() was called
     */
    public static final int REASON_STOP = 5;

    /**
     * Broker would like to exit for some reason.
     * @param reason why the broker would like to exit, one of
     *              <UL><LI>REASON_SHUTDOWN</LI>
     *                  <LI>REASON_RESTART</LI>
     *                  <LI>REASON_FATAL</LI>
     *                  <LI>REASON_ERROR</LI>
     *                  <LI>REASON_EXCEPTION</LI>
     *                  <LI>REASON_STOP</LI></UL>
     * @param info string which indicates when the exit was requested
     * @param thr optional Throwable
     * @return true if the broker should clean up and exit and false
     *         if the request to exit was denied (if the request to
     *         shutdown after a fatal error is denied, the broker may not
     *         respond correctly).
     */
    public boolean exitRequested(int reason, String info,
                  Throwable thr);


    /**
     * Notification that the broker has shutdown.
     */
    public void brokerShutdown();

    /**
     * Notification that the broker has started and is responding to
     * jms requests.
     */
    public void brokerStarted();
}

