/*
 * @(#)Decompressor.java	1.1 04/05/18
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient.zip;

import java.util.zip.*;

import javax.jms.*;

import com.sun.messaging.jmq.jmsclient.Debug;

public class Decompressor {

    private Inflater inflater = new Inflater(false);

    private static Decompressor decompressor = new Decompressor();

    private boolean debug = Boolean.getBoolean("imq.zip.debug");

    private Decompressor () {
    }

    public static Decompressor getInstance() {
        return decompressor;
    }

    public synchronized void
    decompress (byte[] zipBody, byte[] unzipBody) throws JMSException {

        Inflater inf = getDefaultInflater();

        try {
            inf.setInput( zipBody );

            int uncompressedSize = inf.inflate( unzipBody );

            if ( uncompressedSize != unzipBody.length ) {
                //This should never happen!
                throw new JMSException (
                "Error occurred in decompression. unzip size: " +
                uncompressedSize + " expected size: " + unzipBody.length);
            }

            if ( debug ) {
                Debug.getPrintStream().println
                    ("*** decompressor zip size: " + zipBody.length);
                Debug.getPrintStream().println
                    ("*** decompressor unzip size: " + uncompressedSize);
            }

        } catch (DataFormatException e) {
            JMSException jmse = new JMSException (e.toString());
            jmse.setLinkedException(e);
            throw jmse;
        } finally {
            inf.reset();
        }
    }

    private Inflater getDefaultInflater() {
        return this.inflater;
    }

}
