/*
 * @(#)Loggable.java	1.1 05/05/11
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */


package com.sun.messaging.jmq.jmsclient.logging;

/**
 * MQ Loggable interface.
 * <p>
 * An exception can implement this interface to indicate that it is loggable.
 *
 * All JMSExceptions in com.sun.messaging.jms package implement this interface.
 * A Loggable exception thrown from ExceptionHandler.throwJMSException() can be
 * logged in the root logger name space.  The same exception will not be logged
 * again if ExceptionHandler.throwJMSException() is called more than once.
 *
 * XXX HAWK -- add comment here.
 *
 * @author chiaming yang
 * @version 1.0
 */
public interface Loggable {

    /**
     * set state to true if this object is logged.
     * @param state boolean
     */
    public void setLogState (boolean state);

    /**
     * get logging state of this object.
     * @return boolean true if this object is logged.
     */
    public boolean getLogState();

}
