/*
 * @(#)XATopicSessionImpl.java	1.14 05/05/06
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jms.ra.ManagedConnection;

/**
 * An XATopicSession provides a regular TopicSession which can be used to
 * create TopicSubscribers and TopicPublishers (optional).
 *
 * <P>XASession extends the capability of Session by adding access to a JMS
 * provider's support for JTA (optional). This support takes the form of a
 * <CODE>javax.transaction.xa.XAResource</CODE> object. The functionality of
 * this object closely resembles that defined by the standard X/Open XA
 * Resource interface.
 *
 * <P>An application server controls the transactional assignment of an
 * XASession by obtaining its XAResource. It uses the XAResource to assign
 * the session to a transaction; prepare and commit work on the
 * transaction; etc.
 *
 * <P>An XAResource provides some fairly sophisticated facilities for
 * interleaving work on multiple transactions; recovering a list of
 * transactions in progress; etc. A JTA aware JMS provider must fully
 * implement this functionality. This could be done by using the services
 * of a database that supports XA or a JMS provider may choose to implement
 * this functionality from scratch.
 *
 * <P>A client of the application server is given what it thinks is a
 * regular JMS Session. Behind the scenes, the application server controls
 * the transaction management of the underlying XASession.
 *
 * @version     05/05/06 1.14
 * @author      George Tharakan
 *
 * @see         javax.jms.XASession javax.jms.XASession
 * @see         javax.jms.XATopicSession javax.jms.XATopicSession
 */

public class XATopicSessionImpl extends XASessionImpl implements TopicSession, XATopicSession {

    public XATopicSessionImpl
            (ConnectionImpl connection, boolean transacted, int ackMode) throws JMSException {

        super (connection, transacted, ackMode);
    }
 
    public XATopicSessionImpl
            (ConnectionImpl connection, boolean transacted, int ackMode, ManagedConnection mc) throws JMSException {

        super (connection, transacted, ackMode, mc);
    }
 
    /**
     * Get the topic session associated with this XATopicSession.
     *  
     * @return the topic session object.
     *  
     * @exception JMSException if a JMS error occurs.
     */ 
    public TopicSession
    getTopicSession() throws JMSException {
        return (TopicSession) this;
    }

    /**  
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param queueName the name of this queue
    *
    * @return a Queue with the given name.
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public Queue createQueue(String queueName) throws JMSException {
 
        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createQueue");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }
 
    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *  
    * @return a temporary queue identity
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public TemporaryQueue
    createTemporaryQueue() throws JMSException {
 
        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createTemporaryQueue");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }
 
    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *  
    * @param queue the queue to access
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public QueueBrowser
    createBrowser(Queue queue) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createBrowser");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

    /**
    * Throws an IllegalStateException as it is an invalid method for this domain.
    *
    * @param queue the queue to access
    * @param selector the selector to use
    *
    * @exception IllegalStateException Always, since it is an invalid method for
    *            this domain.
    */
    public QueueBrowser
    createBrowser(Queue queue, String selector) throws JMSException {

        String errorString = AdministeredObject.cr.getKString(AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN,
                                                              "createBrowser");
        throw new javax.jms.IllegalStateException(errorString, AdministeredObject.cr.X_ILLEGAL_METHOD_FOR_DOMAIN);
    }

} 
