 /*
 * @(#)StreamHandlerFactory.java	1.1 00/06/21
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

/**
 * StreamHandler factory provides a standard way to get a JMQ StreamHandler.
 */
public class StreamHandlerFactory {
     private static final String defaultProtocol =
               "com.sun.messaging.jmq.jmsclient.protocol.tcp.TCPStreamHandler";

    /**
     * Called by ProtocolHandler to get the specified StreamHandler.
     * @return StreamHandler.  If className is null, the default
     * StreamHandler - TCPStreamHandler is returned.
     */
    public static StreamHandler
    getStreamHandler (String protocolName) throws ClassNotFoundException,
                                IllegalAccessException, InstantiationException {

        String className = null;
        if ( protocolName == null ) {
            className = defaultProtocol;
        } else {
            className = protocolName;
        }

        return (StreamHandler) Class.forName (className).newInstance();
    }

}

