/*
 * @(#)QueueReceiverImpl.java	1.7 02/03/12
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;

/** A client uses a QueueReceiver for receiving messages that have been
  * delivered to a queue.
  *
  * <P>Although it is possible to have multiple QueueReceivers for the same queue,
  * JMS does not define how messages are distributed between the QueueReceivers.
  *
  * @version     1.0 - 9 March 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see         javax.jms.QueueSession#createReceiver(Queue, String)
  * @see         javax.jms.QueueSession#createReceiver(Queue)
  * @see         javax.jms.MessageConsumer
  */

public class QueueReceiverImpl extends MessageConsumerImpl implements QueueReceiver{

    private Queue queue = null;


    public QueueReceiverImpl (SessionImpl session, Queue queue)
                              throws JMSException {

        super (session, queue);
        this.queue = queue;
        //setIsTopic ( false );
        init(); //register interest
    }

    public QueueReceiverImpl (SessionImpl session, Queue queue,
                              String selector) throws JMSException {
        //isTopic is false;
        super (session, queue);
        this.queue = queue;
        //setIsTopic ( false );
        setMessageSelector ( selector );
        init(); //register interest
    }

    /** Get the queue associated with this queue receiver.
      *
      * @return the queue
      *
      * @exception JMSException if JMS fails to get queue for
      *                         this queue receiver
      *                         due to some internal error.
      */

    public Queue
    getQueue() throws JMSException {
        checkState();
        return queue;
    }
}
