/*
 * @(#)MQAddressList.java	1.1 03/21/05
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */

package com.sun.messaging.jmq.jmsclient;

import java.util.Random;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.net.MalformedURLException;

/**
 * This class represents broker address URL.
 */
public class MQAddressList extends com.sun.messaging.jmq.io.MQAddressList {
    public static final int PRIORITY = 1;
    public static final int RANDOM = 2;

	private int behavior;


    protected  com.sun.messaging.jmq.io.MQAddress createMQAddress(String s) 
         throws java.net.MalformedURLException
   {
            return com.sun.messaging.jmq.jmsclient.MQAddress.createMQAddress(s);
    }

    public static MQAddressList createMQAddressList(String addrs)
        throws MalformedURLException {
        MQAddressList alist = new MQAddressList();
        StringTokenizer st = new StringTokenizer(addrs, " ,");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            alist.add(alist.createMQAddress(s));
        }

        return alist;
    }

	public int getBehavior() {
		return behavior;
	}

	public void setBehavior(int behavior) {
		this.behavior = behavior;

        if (behavior == RANDOM) {
            // Randomize the sequence.
            Random r = new Random();
            int max = size();

            for (int i = 0; i < max; i++) {
                int pos = i + r.nextInt(max - i);

                Object o = get(i);
                set(i, get(pos));
                set(pos, o);
            }
        }
	}

    public String toString() {
        String ret = "";
        for (int i = 0; i < size(); i++) {
            ret = ret + "addr[" + i + "] :\t" + get(i) + "\n";
        }

        return ret;
    }

    public static void main(String[] args) throws Exception {
        MQAddressList list = createMQAddressList(args[0]); 
        if (System.getProperty("test.random") != null)
            list.setBehavior(RANDOM);
        System.out.println(list);
    }
}

/*
 * EOF
 */
