/*
 * @(#)ConnectionConsumerReader.java	1.1 00/08/02
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.jmsclient;

import javax.jms.*;
import com.sun.messaging.jmq.io.*;
import java.io.*;

/**
 * A ConnectionConsumerReader reads off messages from the connection
 * consumer's Read Queue and delivers the messages to the connection
 * consumer which will load the messages to ServerSessions
 *
 * @version     JMQ 2.0
 * @author      Amy Kang 
 */

//XXX REVISIT
public class ConnectionConsumerReader extends ConsumerReader {
    private ConnectionConsumerImpl connectionConsumer = null;
    private int load = 0;
    private int maxMessages;

    public ConnectionConsumerReader(ConnectionConsumerImpl connectionConsumer) {
        super(connectionConsumer.getConnection(), 
              connectionConsumer.getReadQueue());

       this.connectionConsumer = connectionConsumer;
       maxMessages = connectionConsumer.getMaxMessages();
       if (maxMessages < 1) { //should not happen
           maxMessages = 1;
       }
       load = 0;
    }

    protected void deliver(ReadOnlyPacket packet) throws IOException, JMSException {
        MessageImpl message = protocolHandler.getJMSMessage(packet);
        if (maxMessages == 1) {
            connectionConsumer.onMessage(message);
            connectionConsumer.startServerSession();
        }
		else {
            if (load == 0) {
                //'sessionQueue' really should named as 'readQueue'
                load = sessionQueue.size() + 1;
                if (load > maxMessages) {
                    load = maxMessages;
                }
            }
            connectionConsumer.onMessage(message);
            load--;
            if (load == 0) {
                connectionConsumer.startServerSession();
            }
        }
	}

    protected void deliver() throws IOException, JMSException {
        //should not happen
    }

    public void dump (PrintStream ps) {
        ps.println ("------ ConnectionConsumerReader dump ------");
        ps.println ("maxMessages: " + maxMessages);
        ps.println ("current load: " + load);
        super.dump(ps);
    }

}

