/*
 * @(#)PacketString.java	1.5 03/04/11
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package com.sun.messaging.jmq.io;

/**
 * This class enumerates all of the JMQ header string field types
 * and provides some convenience routines.
 *
 * @version 1.5 03/04/11
 */
public class PacketString {
    public static final int NULL          = 0;
    public static final int DESTINATION   = 1;
    public static final int MESSAGEID     = 2;
    public static final int CORRELATIONID = 3;
    public static final int REPLYTO       = 4;
    public static final int TYPE          = 5;
    public static final int DESTINATION_CLASS = 6;
    public static final int REPLYTO_CLASS     = 7;
    public static final int TRANSACTIONID     = 8;
    public static final int PRODUCERID        = 9;
    public static final int LAST              = 10;

    public static final String[] names = {
	"NULL", "JMSDestination", "JMSMessageID",
	"JMSCorrelationID", "JMSReplyTo", "JMSType", "DestinationClass",
	"ReplyToClass", "TransacionID", "ProducerID"};

    /**
     * Return a string description of the specified string type
     *
     * @param    n    Type to return description for
     */
    public static String getString(int n) {
	if (n < 0 || n >= LAST) {
	    return "INVALID_STRING";
	}

	return names[n] + "(" + n + ")";
    }
}
