

/*
 * @(#)PacketProperties.java	1.4 03/05/09
 *
 * Copyright 2002 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package com.sun.messaging.jmq.io;

import java.io.*;
import java.util.*;
import java.nio.ByteBuffer;
import java.nio.charset.*;

/**
 *
 * @version 1.4 03/05/09
 *
 */

/*
 * Only the follow property types are supported:
 *    Boolean, Byte, Short, Integer, Long, Float, Double, and String
 *
 * Format:
 *     [Name length][Name (UTF-8)][Value type][Value Length][Value]
 *
 *    Pad out to 32 bit boundry
 * 
 */   
public class PacketProperties 
{
    public static final short BOOLEAN = 1; 
    public static final short BYTE = 2;
    public static final short SHORT = 3;
    public static final short INTEGER = 4;
    public static final short LONG = 5;
    public static final short FLOAT = 6;
    public static final short DOUBLE = 7;
    public static final short STRING = 8;
    public static final short OBJECT = 9;

    public static final int VERSION1=1;

    // add OBJECT

    // add version comment

    public static void write(Map map, OutputStream os) 
            throws IOException
    {
        if (map == null) {
            return;
        }
        DataOutputStream dos = new DataOutputStream(os);

        dos.writeInt(VERSION1);
        dos.writeInt(map.size());
        Iterator itr = map.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String) itr.next();
            Object value = map.get(key);
            dos.writeUTF(key);
            if (value instanceof Boolean) {
                dos.writeShort(BOOLEAN);
                dos.writeBoolean(((Boolean)value).booleanValue());
            } else if (value instanceof Byte) {
                dos.writeShort(BYTE);
                dos.writeByte(((Byte)value).byteValue());
            } else if (value instanceof Short) {
                dos.writeShort(SHORT);
                dos.writeShort(((Short)value).shortValue());
            } else if (value instanceof Integer) {
                dos.writeShort(INTEGER);
                dos.writeInt(((Integer)value).intValue());
            } else if (value instanceof Long) {
                dos.writeShort(LONG);
                dos.writeLong(((Long)value).longValue());
            } else if (value instanceof Float) {
                dos.writeShort(FLOAT);
                dos.writeFloat(((Float)value).floatValue());
            } else if (value instanceof Double) {
                dos.writeShort(DOUBLE);
                dos.writeDouble(((Double)value).doubleValue());
            } else if (value instanceof String) {
                dos.writeShort(STRING);
                dos.writeUTF((String)value);
            } else {
                dos.writeShort(OBJECT);
                JMQByteArrayOutputStream bos = 
                    new JMQByteArrayOutputStream(new byte[256]);
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                oos.close();
                byte[] data = bos.getBuf();
                dos.writeInt(data.length);
                dos.write(data, 0, data.length);
            }
        }      
    }

    public static Hashtable parseProperties(InputStream is) 
        throws IOException, ClassNotFoundException
    {
        DataInputStream dis = new DataInputStream(is);

        int version = dis.readInt();
        if (version != VERSION1) {
            throw new IOException("Unsupported version of properties serialization ["
                    + version + "]");
        }
        int propcnt = dis.readInt();
        Hashtable ht = new Hashtable(propcnt);

        int cnt = 0;
        while (cnt < propcnt) {
            String key = dis.readUTF();
            if (key == null || key.length() <= 0) break;

            short type = dis.readShort();

            Object value = null;
            switch( type) {
                case BOOLEAN:
                    value = new Boolean(dis.readBoolean());
                    break;
                case BYTE:
                    value = new Byte(dis.readByte());
                    break;
                case SHORT:
                    value = new Short(dis.readShort());
                    break;
                case INTEGER:
                    value = new Integer(dis.readInt());
                    break;
                case LONG:
                    value = new Long(dis.readLong());
                    break;
                case FLOAT:
                    value = new Float(dis.readFloat());
                    break;
                case DOUBLE:
                    value = new Double(dis.readDouble());
                    break;
                case STRING:
                    value = dis.readUTF();
                    break;
                case OBJECT:
                    int bytes = dis.readInt();
                    byte[] buf = new byte[bytes];
                    dis.read(buf,0,bytes);
                    JMQByteArrayInputStream bis = 
                        new JMQByteArrayInputStream(buf);
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    value = ois.readObject();
                    ois.close();
                    bis.close();
                default:
                      // ignore (dont throw exception)
            }
            ht.put(key, value);
            cnt ++;
        }      
        
        return ht;
    }



    
}
