/*
 * @(#)PacketFlag.java	1.9 05/03/21
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 *
 */

package com.sun.messaging.jmq.io;


/**
 * This class defines the JMQ packet bit flags and provides some
 * convenience routines.
 *
 * @version 1.9 05/03/21
 */
public class PacketFlag {

    public static final int Q_FLAG =  0x0001;
    public static final int R_FLAG =  0x0002;
    public static final int P_FLAG =  0x0004;
    public static final int S_FLAG =  0x0008;
    public static final int A_FLAG =  0x0010;
    public static final int L_FLAG =  0x0020;
    public static final int F_FLAG =  0x0040;
    public static final int T_FLAG =  0x0080;
    public static final int C_FLAG =  0x0100;
    public static final int B_FLAG =  0x0200;
    public static final int Z_FLAG =  0x0400;
    public static final int I_FLAG =  0x0800;

    /**
     * Return a human readable string describing the bits set in "flags"
     */
    public static String getString(int flags) {
	String s =
	    ((flags & A_FLAG) == A_FLAG ? "A" : "") +
	    ((flags & S_FLAG) == S_FLAG ? "S" : "") +
	    ((flags & P_FLAG) == P_FLAG ? "P" : "") +
	    ((flags & R_FLAG) == R_FLAG ? "R" : "") +
	    ((flags & Q_FLAG) == Q_FLAG ? "Q" : "") +
	    ((flags & L_FLAG) == L_FLAG ? "L" : "") +
	    ((flags & F_FLAG) == F_FLAG ? "F" : "") +
	    ((flags & T_FLAG) == T_FLAG ? "T" : "") +
	    ((flags & B_FLAG) == B_FLAG ? "B" : "") +
	    ((flags & Z_FLAG) == Z_FLAG ? "Z" : "") +
	    ((flags & C_FLAG) == C_FLAG ? "C" : "") +
	    ((flags & I_FLAG) == I_FLAG ? "I" : "");

        return s;
    }

}
