/*
 * @(#)MQConnectionPermission.java	1.2 05/11/17
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.auth.jaas;

/**
 * This class is for MQ service connection permissions.  It contains
 * a name (also referred to as a "target name") but no actions list;
 * you either have the named permission or you don't.
 *
 * @author      Amy Kang
 */

public final class MQConnectionPermission extends MQBasicPermission 
{ 

    private static final long serialVersionUID = 1919911567794615301L;

    /**
     *
     */
    public MQConnectionPermission(String name) {
        super(name);
    }

    public void validateName(String name) throws IllegalArgumentException {
        if (!name.equals(PermissionFactory.CONN_NORMAL) && 
            !name.equals(PermissionFactory.CONN_ADMIN)) {
            throw new IllegalArgumentException("invalidate name "+name);
        }
    }
}
