/*
 * @(#)DigestAuthenticationHandler.java	1.8 05/11/09
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.auth.handlers;

import java.io.*;
import java.util.Hashtable;
import javax.security.auth.login.LoginException;
import com.sun.messaging.jmq.auth.api.client.*;
import com.sun.messaging.jmq.util.MD5;

/**
 * MQ 'digest' authentication request handler
 */

public class DigestAuthenticationHandler implements AuthenticationProtocolHandler {

    private String username = null;
    private String password = null;

    public String getType() {
        return "digest";
    }

    /**
     * This method is called right before start a authentication process
     * Currently for JMQ2.0, username/password always have values (if not
     * passed in createConnection() call, they are assigned default values).
     */
    public void init(String username, String password,
                     Hashtable authProperties) throws LoginException {
        this.username = username;
        this.password = password;
    }


    public byte[] handleRequest(byte[] authRequest, int sequence) 
                                throws LoginException {
        if (username == null || password == null) {
            throw new LoginException("null");
        }
        try {

        byte[] response;
        byte[] nonce = authRequest;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
		dos.writeUTF(username);
        String userpwd = MD5.getHashString(username + ":" + password);
        try {
        String credential = MD5.getHashString(userpwd + ":" + new String(nonce, "UTF8"));
        dos.writeUTF(credential);
        } catch (UnsupportedEncodingException e) {
        throw new IOException(e.getMessage());
        }
        dos.flush();
        response = bos.toByteArray();
        dos.close();
        return response;

        } catch (IOException e) {
        throw new LoginException("IOException: "+e.getMessage());
        }
    }
}
