/*
 * @(#)AccessControlContext.java	1.4 05/11/09
 *
 * Copyright 2005 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */
package com.sun.messaging.jmq.auth.api.server;

import java.util.Properties;
import java.security.Principal;
import java.security.AccessControlException;

/**
 * An AccessControlContext encapsulates a context for the current authenticated
 * user (the subject) and permissions.  It has 2 check permission methods,
 *
 * checkConnectionPermission
 * checkDestinationPermission
 *
 * It makes these access decisions based on the context it encapsulates.
 * An object of AccessControlContext is returned from
 *
 * AuthenticationProtocolHandler.getAccessControlContext()
 *
 * after the login() (authentication) compeletes successfully.
 * 
 * @version     JMQ 2.0
 * @author      Amy Kang
 * 
 */

public interface AccessControlContext {

    /**
     *
     * @return The Principal that represents the client user 
     *         that associated with the subject. 
     */
    public Principal getClientUser();

    /**
     * Check connection permission based on the access control context
     *
     * @param serviceName The name of the service instance the connection belongs
     * @param serviceType The service type as in broker configuration <BR>
     *                    ("NORMAL" or "ADMIN") <BR>
     *
     * @exception AccessControlException
     */
    public void checkConnectionPermission(String serviceName,
                                          String serviceType)
                                          throws AccessControlException;

    /**
     * Check permission for an operation on a destination based on the 
     * access control context. 
     * 
     * @param serviceName The name of the service instance the connection belongs
     * @param serviceType The service type as in broker configuration <BR>
     *                    ("NORMAL" or "ADMIN") <BR>
     * @param operation "send" "receive" "publish" "subscribe" "browse"
     * @param destination The destination name
     * @param destinationType "queue" or "topic"
     *
     * @exception AccessControlException
     */
    public void checkDestinationPermission(String serviceName,
                                           String serviceType,
                                           String operation,
                                           String destination,
                                           String destinationType)
                                           throws AccessControlException; 
}
