/*
 * @(#)Globals.java	1.13 04/08/25
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms. 
 *
 */


package com.sun.messaging.jmq.admin.util;

import java.io.*;
import java.util.ResourceBundle;
import java.util.Locale;
import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.util.log.Logger;

import java.io.File;
/**
 * Singleton class which contains any Globals for the
 * system.<P>
 *
 * Other singleton classes which can be considered static
 * once they are retrieved (they do not need to be retrieved
 * from the static method each time they are used) should
 * also be defined here <P>
 */

public class Globals
{
    private static final Object lock = Globals.class;

    private static Version version = null;

    private static Globals globals = null;

    private static AdminResources ar = null;
    private static AdminConsoleResources acr = null;

    private static Logger logger = null;
    private static boolean silentMode = false;

    //------------------------------------------------------------------------
    //--                 static brokerConfig objects                 --
    //------------------------------------------------------------------------
  
    private Globals() {
    }

    public static Globals getGlobals() {
        if (globals == null) {
            synchronized(lock) {
                if (globals == null)
                    globals = new Globals();
            }
        }
        return globals;
    }

    public static Version getVersion()  {
	if (version == null)  {
	    version = new Version();
	}

	return (version);
    }

    public static AdminResources getAdminResources() {
	if (ar == null) {
            synchronized(lock) {
	        if (ar == null) {
	            ar = AdminResources.getResources(Locale.getDefault());
		}
	    }
	}
	return ar;
    }

    public static AdminConsoleResources getAdminConsoleResources() {
	if (acr == null) {
            synchronized(lock) {
	        if (acr == null) {
	            acr = AdminConsoleResources.getResources(Locale.getDefault());
		}
	    }
	}
	return acr;
    }

/*
    public static Logger getLogger() {
	if (logger == null) {
            synchronized(lock) {
	        if (logger == null) {
		    logger = new Logger(JMQ_VAR_HOME);
		    logger.setResourceBundle(getAdminResources());
		}
	    }
	}
	return logger;
    }
*/

    /*---------------------------------------------
     *          global static variables
     *---------------------------------------------*/

    /**
     * system property name for the non-editable JMQ home location
     */
    public static final String JMQ_HOME_PROPERTY="imq.home";

    /**
     * system property name for the editable JMQ home location
     */
    public static final String JMQ_VAR_HOME_PROPERTY="imq.varhome";

    /**
     * system property name for the /usr/share/lib location
     */
    public static final String JMQ_LIB_HOME_PROPERTY="imq.libhome";

    /**
     * default value for the non-editable JMQ home location (used if
     * the system property is not set)
     */
    public static final String JMQ_HOME_default = ".";

    /**
     * default value for the non-editable JMQ home location (used if
     * the system property is not set)
     */
    public static final String JMQ_VAR_HOME_default = "var";

    /**
     * location the configuration is using for the non-editable home location
     */
    public static final String JMQ_HOME = System.getProperty(JMQ_HOME_PROPERTY,JMQ_HOME_default); 

    /**
     * location the configuration is using for the editable home location
     */
    public static final String JMQ_VAR_HOME = System.getProperty(JMQ_VAR_HOME_PROPERTY,JMQ_HOME + File.separator + JMQ_VAR_HOME_default);

    /**
     * location the configuration is using for the share lib home location
     */
    public static final String JMQ_LIB_HOME = System.getProperty(JMQ_LIB_HOME_PROPERTY,JMQ_HOME + File.separator + "lib") ;


    /**
     * subdirectory under either the editable or non-editable location where the 
     * configuration files are location
     */
    public static final String JMQ_ADMIN_PROP_LOC = "props"+File.separator + "admin"+File.separator;

    /*---------------------------------------------
     * Global error printing methods.
     *---------------------------------------------*/

    public static void setSilentMode(boolean mode) {
	silentMode = mode;
    }

    public static void stdErrPrintln(String msg) {
        doPrintln(System.err, msg, false);
    }

    public static void stdErrPrintln(String msg, boolean exit) {
        doPrintln(System.err, msg, exit);
    }

    public static void stdErrPrintln(String type, String msg) {
        doPrintln(System.err, type + " " + msg, false);
    }

    public static void stdErrPrintln(String type, String msg, boolean exit) {
        doPrintln(System.err, type + " " + msg, exit);
    }

    public static void stdOutPrintln(String msg) {
        doPrintln(System.out, msg, false);
    }

    public static void stdOutPrintln(String msg, boolean exit) {
        doPrintln(System.out, msg, exit);
    }

    public static void stdOutPrintln(String type, String msg) {
        doPrintln(System.out, type + " " + msg, false);
    }

    public static void stdOutPrintln(String type, String msg, boolean exit) {
        doPrintln(System.out, type + " " + msg, exit);
    }

    public static void stdErrPrint(String msg) {
        doPrint(System.err, msg, false);
    }

    public static void stdErrPrint(String msg, boolean exit) {
        doPrint(System.err, msg, exit);
    }

    public static void stdErrPrint(String type, String msg) {
        doPrint(System.err, type + " " + msg, false);
    }

    public static void stdErrPrint(String type, String msg, boolean exit) {
        doPrint(System.err, type + " " + msg, exit);
    }

    public static void stdOutPrint(String msg) {
        doPrint(System.out, msg, false);
    }

    public static void stdOutPrint(String msg, boolean exit) {
        doPrint(System.out, msg, exit);
    }

    public static void stdOutPrint(String type, String msg) {
        doPrint(System.out, type + " " + msg, false);
    }

    public static void stdOutPrint(String type, String msg, boolean exit) {
        doPrint(System.out, type + " " + msg, exit);
    }

    private static void doPrintln(PrintStream out, String msg, boolean exit) {
	if (silentMode)  {
	    return;
	}

        out.println(msg);
	if (exit)
	    System.exit(1);
    }

    private static void doPrint(PrintStream out, String msg, boolean exit) {
	if (silentMode)  {
	    return;
	}

        out.print(msg);
	if (exit)
	    System.exit(1);
    }
}

