/*
 * @(#)BrokerAdminUtil.java	1.2 03/04/11
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.util.DestType;

/**
 * Class containing useful methods for broker administration.
 */
public class BrokerAdminUtil {

    private static AdminResources ar = Globals.getAdminResources();

    public static String getDestinationType(int mask) {
        if (DestType.isTopic(mask))
            return ar.getString(ar.I_TOPIC);
        else if (DestType.isQueue(mask))
            return ar.getString(ar.I_QUEUE);
        else
            return ar.getString(ar.I_UNKNOWN);
    }

    public static String getDestinationFlavor(int mask) {
        if (DestType.isTopic(mask))
            return "-";
        else if (DestType.isSingle(mask))
            return ar.getString(ar.I_SINGLE);
        else if (DestType.isRRobin(mask))
            return ar.getString(ar.I_RROBIN);
        else if (DestType.isFailover(mask))
            return ar.getString(ar.I_FAILOVER);
        else if (DestType.isQueue(mask))
            return ar.getString(ar.I_SINGLE);  // This is the default
        else
            return ar.getString(ar.I_UNKNOWN);
    }

    public static String getActiveConsumers(int mask, int value) {
        if (DestType.isTopic(mask))
            return "-";
        else {
	    if (value == -1) 
		return ar.getString(ar.I_UNLIMITED);
	    else
	    	return new Integer(value).toString();
	}
    }

    public static String getFailoverConsumers(int mask, int value) {
        if (DestType.isTopic(mask))
            return "-";
        else {
	    if (value == -1) 
		return ar.getString(ar.I_UNLIMITED);
	    else
	    	return new Integer(value).toString();
	}
    }
}
