/*
 * @(#)ConsoleActionEvent.java	1.5 01/02/02
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 */

package com.sun.messaging.jmq.admin.apps.console.event;

import java.util.EventObject;

/**
 * Events related to high level semantic console operations like exit, about,
 * add, preferences, etc.
 *
 * @version     1.5 01/02/02
 * @author      Isa Hashim
 */
public class ConsoleActionEvent extends AdminEvent {
    /*
     * Event type
     */
    public final static int	ABOUT 		= 0;
    public final static int	PREFERENCES	= 1;
    public final static int	EXPAND_ALL	= 2;
    public final static int	COLLAPSE_ALL	= 3;
    public final static int	EXIT	 	= 4;
    public final static int	REFRESH	 	= 5;

    /**
     * Creates an instance of ConsoleActionEvent
     * @param source the object where the event originated
     */
    public ConsoleActionEvent(Object source) {
	super(source);
    }

    /**
     * Creates an instance of ConsoleActionEvent of the specified type.
     * @param source the object where the event originated
     * @param type the type of event
     */
    public ConsoleActionEvent(Object source, int type) {
	super(source, type);
    }
}
