/*
 * @(#)ReadOnlyPropertyException.java	1.2 00/10/12
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging;

import javax.jms.JMSException;

/**
 * A <code>ReadOnlyPropertyException</code> is thrown when an attempt is
 * made to modify a JMQ <code>AdministeredObject</code> that has been
 * set to read only.
 *
 * @version     1.2 00/10/12
 * @author      George Tharakan
 *
 * @see         javax.jms.ConnectionFactory javax.jms.ConnectionFactory
 * @see         com.sun.messaging.AdministeredObject#setReadOnly() com.sun.messaging.AdministeredObject.setReadOnly()
 */
public class ReadOnlyPropertyException extends javax.jms.JMSException {

    /**
     * Constructs a ReadOnlyPropertyException.
     *
     * @param property The property being modified.
     */  
    public ReadOnlyPropertyException(String property) {
        super(property);
    }


}

