/*
 * @(#)PropertyOwner.java	1.3 00/11/05
 *
 * Copyright 2000 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging;

/**
 * The <code>PropertyOwner</code> interface is implemented by any property that owns
 * other properties. The property type of this property is <code>com.sun.messaging.PropertyOwner</code>.
 * <p>
 * Setting a property Type to <code>com.sun.messaging.PropertyOwner</code> indicates
 * that dependant property information can be obtained from the class via the
 * interface methods described below.
 *
 * @version     1.3 00/11/05
 * @author      George Tharakan
 */

public interface PropertyOwner {
    /**
     * Returns a String array of property names that this <code>PropertyOwner</code>
     * owns.
     *
     * @return The String array of property names that this <code>PropertyOwner</code> owns.
     */
    public String[] getPropertyNames();

    /**
     * Returns the type of a single owned property.
     * 
     * @param propname The name of the owned property.
     *
     * @return The type of the owned property <code>propname</code>.
     *         <code>null</code> if the property <code>propname</code> is invalid.
     */
    public String getPropertyType(String propname);

    /**
     * Returns the label of a single owned property.
     * 
     * @param propname The name of the owned property.
     *
     * @return The label of the owned property <code>propname</code>.
     *         <code>null</code> if the property <code>propname</code> is invalid.
     */
    public String getPropertyLabel(String propname);

    /**  
     * Returns the default value of a single owned property.
     *   
     * @param propname The name of the owned property.
     *   
     * @return The default value of the owned property <code>propname</code>.
     *         <code>null</code> if the property <code>propname</code> is invalid.
     */  
    public String getPropertyDefault(String propname);
}
