/*
 * @(#)DestinationConfiguration.java	1.8 04/07/14
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging;

/**
 * The <code>DestinationConfiguration</code> class contains Sun MQ specific
 * destination identity configuration property names and values.
 * 
 * @version     1.8 04/07/14
 * @author      George Tharakan
 *
 * @see         com.sun.messaging.Destination com.sun.messaging.Destination
 */
public class DestinationConfiguration {

    /* No public constructor needed */ 
    private DestinationConfiguration() {} 

    /**
     * The property name that holds the name assigned to the
     * <code>Destination</code> object.
     */
    public static final String imqDestinationName = "imqDestinationName";

    /**
     * @deprecated
     * @see com.sun.messaging.DestinationConfiguration#imqDestinationName
     */
    public static final String JMQDestinationName = imqDestinationName;

    /**
     * The property name that holds a description given to the
     * <code>Destination</code> object.
     */
    public static final String imqDestinationDescription = "imqDestinationDescription";

    /**
     * @deprecated
     * @see com.sun.messaging.DestinationConfiguration#imqDestinationDescription
     */
    public static final String JMQDestinationDescription = imqDestinationDescription;

    /**
     * The default name initially given to a <code>Destination</code> object
     * upon instantiation. Typically, either the administrator or programmer will
     * assign a name for this <code>Destination</code> object.
     *
     * @see com.sun.messaging.Destination com.sun.messaging.Destination
     */
    public static final String IMQ_INITIAL_DESTINATION_NAME = "Untitled_Destination_Object";

    /**
     * The default description initially given to a <code>Destination</code> object
     * upon instantiation. Typically, either the administrator or programmer will
     * set a meaningful description for this <code>Destination</code> object.
     *
     * @see com.sun.messaging.Destination com.sun.messaging.Destination
     */
    public static final String IMQ_INITIAL_DESTINATION_DESCRIPTION = "A Description for the Destination Object";
}
