/*
 * @(#)ConnectionFactory.java	1.23 04/07/14
 *
 * Copyright 2004 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

package com.sun.messaging;

import javax.jms.*;
import com.sun.messaging.naming.ReferenceGenerator;
import com.sun.messaging.jmq.jmsclient.QueueConnectionImpl;
import com.sun.messaging.jmq.jmsclient.TopicConnectionImpl;

/**
 * A <code>ConnectionFactory</code> is used to create Connections with
 * the Sun MQ Java Message Service (JMS) provider.
 *
 * @version     1.23 04/07/14
 * @author      George Tharakan
 *
 * @see         javax.jms.ConnectionFactory javax.jms.ConnectionFactory
 * @see         com.sun.messaging.ConnectionConfiguration com.sun.messaging.ConnectionConfiguration
 */
public class ConnectionFactory extends BasicConnectionFactory implements javax.naming.Referenceable {

    /**
     * Constructs a ConnectionFactory with the default configuration.
     *
     */
    public ConnectionFactory() {
        super();
    }

    /**
     * Constructs a ConnectionFactory with the specified configuration.
     *
     */
    protected ConnectionFactory(String defaultsBase) {
        super(defaultsBase);
    }

    /**
     * Creates a Queue Connection with the default user identity. The default user identity
     * is defined by the <code>ConnectionFactory</code> properties
     * <code><b>imqDefaultUsername</b></code> and <code><b>imqDefaultPassword</b></code>
     *   
     * @return a newly created Queue Connection.
     *   
     * @exception JMSException if a JMS error occurs.
     * @see ConnectionConfiguration#imqDefaultUsername
     * @see ConnectionConfiguration#imqDefaultPassword
     */  
    public QueueConnection createQueueConnection() throws JMSException {
        return createQueueConnection(getProperty(ConnectionConfiguration.imqDefaultUsername),
                                     getProperty(ConnectionConfiguration.imqDefaultPassword));
    }
 
    /**
     * Creates a Queue Connection with a specified user identity.
     * 
     * @param username the caller's user name
     * @param password the caller's password
     *
     * @return a newly created queue connection.
     *
     * @exception JMSException if a JMS error occurs.
     */
    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return new QueueConnectionImpl(getCurrentConfiguration(), username, password, getConnectionType());
    }

    /**
     * Creates a Topic Connection with the default user identity. The default user identity
     * is defined by the <code>ConnectionFactory</code> properties
     * <code><b>imqDefaultUsername</b></code> and <code><b>imqDefaultPassword</b></code>
     *   
     * @return a newly created Topic Connection.
     *   
     * @exception JMSException if a JMS error occurs.
     * @see ConnectionConfiguration#imqDefaultUsername
     * @see ConnectionConfiguration#imqDefaultPassword
     */  
    public TopicConnection createTopicConnection() throws JMSException {
        return createTopicConnection(getProperty(ConnectionConfiguration.imqDefaultUsername),
                                     getProperty(ConnectionConfiguration.imqDefaultPassword));
    }
 
    /**
     * Creates a Topic Connection with a specified user identity.
     * 
     * @param username the caller's user name
     * @param password the caller's password
     *
     * @return a newly created topic connection.
     *
     * @exception JMSException if a JMS error occurs.
     */
    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return new TopicConnectionImpl(getCurrentConfiguration(), username, password, getConnectionType());
    }

    /**
     * Returns the reference to this object.
     *   
     * @return  The Reference Object that can be used to reconstruct this object
     *   
     */
    public javax.naming.Reference getReference() {
        return (ReferenceGenerator.getReference(this,
                com.sun.messaging.naming.AdministeredObjectFactory.class.getName()));
    }
}
