/*
 * @(#)JMSXATopicSession.java	1.2 01/11/30
 * Original @(#)JMSXATopicSession.java	1.2 00/11/21
 *
 * Copyright 1997-2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package com.sun.jms.spi.xa;

import javax.jms.*;

/** An JMSXATopicSession provides a regular TopicSession which can be used to
  * create TopicSubscribers and TopicPublishers (optional).
  *
  * @version     1.0 - 14 May 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see         com.sun.jms.spi.xa.JMSXASession
  * @see         javax.jms.TopicSession
  */

public interface JMSXATopicSession extends JMSXASession {

    /** Get the topic session associated with this JMSXATopicSession object.
      *   
      * @return the topic session object. 
      *   
      * @exception JMSException if a JMS error occurs.
      */  
  
    TopicSession 
    getTopicSession() throws JMSException;
}
