/*
 * @(#)JMSXASession.java	1.2 01/11/30
 * Original @(#)JMSXASession.java	1.2 00/11/21
 *
 * Copyright 1997-2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package com.sun.jms.spi.xa;

import javax.jms.*;
import javax.transaction.xa.XAResource;

/** XASession provides access to a JMS provider's support for JTA (optional) 
  * and the associated Session. This support takes the form of a 
  * <CODE>javax.transaction.xa.XAResource</CODE> object. The functionality of 
  * this object closely resembles that defined by the standard X/Open XA 
  * Resource interface.
  *
  * <P>An application server controls the transactional assignment of an 
  * JMSXASession by obtaining its XAResource. It uses the XAResource to assign 
  * the session to a transaction; prepare and commit work on the
  * transaction; etc.
  *
  * <P>An XAResource provides some fairly sophisticated facilities for 
  * interleaving work on multiple transactions; recovering a list of 
  * transactions in progress; etc. A JTA aware JMS provider must fully 
  * implement this functionality. This could be done by using the services 
  * of a database that supports XA or a JMS provider may choose to implement 
  * this functionality from scratch.
  *
  * <P>A client of the application server is given what it thinks is a 
  * regular JMS Session. Behind the scenes, the application server controls 
  * the transaction management of the underlying JMSXASession.
  * 
  * @version     1.0 - 13 August 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see         com.sun.jms.xa.spi.JMSXAQueueSession
  * @see         com.sun.jms.xa.spi.JMSXATopicSession
  */ 
 
public interface JMSXASession {

    /** Return an XA resource to the caller.
      *
      * @return an XA resource to the caller
      */

     XAResource
     getXAResource();


    /*
     * return a Session associated with this XASession object.
     *
     * @return a Session to the caller
     *  
     * @exception JMSException if a JMS error occurs.
     */

    Session getSession() throws JMSException;
    
    /*
     * close the JMSXASession.
     *
     * @exception JMSException if a JMS error occurs.
     */
    void close() throws JMSException;
}
