/*
 * @(#)JMSXAQueueSession.java	1.2 01/11/30
 * Original @(#)JMSXAQueueSession.java	1.2 00/11/21
 *
 * Copyright 1997-2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */

package com.sun.jms.spi.xa;

import javax.jms.*;

/** An JMSXAQueueSession provides a regular QueueSession which can be used to
  * create QueueReceivers, QueueSenders and QueueBrowsers (optional).
  *
  * @version     1.0 - 13 March 1998
  * @author      Mark Hapner
  * @author      Rich Burridge
  *
  * @see         com.sun.jms.spi.xa.XASession
  * @see         javax.jms.QueueSession
  */

public interface JMSXAQueueSession extends JMSXASession {

    /** Get the queue session associated with this JMSXAQueueSession object.
      *  
      * @return the queue session object.
      *  
      * @exception JMSException if a JMS error occurs.
      */ 
 
    QueueSession
    getQueueSession() throws JMSException;
}
