/*
 * @(#)JMSAdminFactory.java	1.2 01/11/30
 * Original @(#)JMSAdminFactory.java	1.2 00/11/21
 * 
 * Copyright 2000-2001 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.
 * Use is subject to license terms.
 * 
 */
package com.sun.jms.spi;
import javax.jms.JMSException;

/**
 * Interface definition to return an instance which implements JMSAdmin. 
 *
 * @author   Martin D. Flynn
 */

public interface JMSAdminFactory
{

    /**
     * Create/return an instance implementing JMSAdmin.
     * @param jmsAdminURL JMSAdmin URL
     * @param userName        
     * @param password 
     * @return Implementation of JMSAdmin.
     * @exception JMSException thrown if JMSAdmin could not be created/returned.
     */
    JMSAdmin getJMSAdmin(String jmsAdminURL, 
                         String userName, String password)
        throws JMSException;

    /**
     * Create/return an instance implementing JMSAdmin.
     * @param jmsAdminURL JMSAdmin URL
     * @return Implementation of JMSAdmin.
     * @exception JMSException thrown if JMSAdmin could not be created/returned.
     */
    JMSAdmin getJMSAdmin(String jmsAdminURL)
        throws JMSException;

}


