/*
 * @(#) 1.14
 *
 * Copyright 2003 Sun Microsystems, Inc. All Rights Reserved
 * SUN PROPRIETARY/CONFIDENTIAL
 * Use is subject to license terms.
 *
 */

#ifndef MQ_CALLBACK_TYPES_H
#define MQ_CALLBACK_TYPES_H

/*
 * defines MQ C-API callback types 
 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "mqtypes.h"

/**
 * This callback is used to notify the user that an exception occurred.
 *
 * @param connectionHandle a handle to the connection on which the
 *        connection exception occurred
 * @param exception the connection exception that occurred
 * @param callbackData whatever void * pointer that was passed to
 *        MQCreateConnection
 * @see MQCreateConnection.  */
typedef void (*MQConnectionExceptionListenerFunc)(
                                const MQConnectionHandle  connectionHandle,
                                MQStatus                  exception,
                                void *                    callbackData );

/**
 * This callback is used for asynchronous receiving messages
 *
 * @param sessionHandle a handle to the session
 * @param consumerHandle a handle to the message consumer 
 * @param messageHandle a handle to the message 
 * @param callbackData whatever void * pointer that was passed to
 *        MQCreateAsyncMessageConsumer or MQCreateAsyncDurableMessageConsumer
 * @see MQCreateAsyncMessageConsumer and MQCreateAsyncDurableMessageConsumer. */
typedef MQError (*MQMessageListenerFunc)(const MQSessionHandle  sessionHandle,
                                         const MQConsumerHandle consumerHandle,
                                         MQMessageHandle        messageHandle,
                                         void *                 callbackData);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* MQ_CALLBACK_TYPES_H */
