/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import [Ljavax.management.ObjectName;;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jms.management.server.DestinationNotification;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class DestinationManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;
    private static String[] dstNotificationTypes;
    private static MBeanNotificationInfo[] notifs;

    public Integer getNumDestinations() {
        List list = DestinationUtil.getVisibleDestinations();
        return new Integer(list.size());
    }

    public Long getNumMsgs() {
        return new Long(Destination.totalCount());
    }

    public Long getNumMsgsInDMQ() {
        return new Long(Destination.getDMQ().size());
    }

    public Long getTotalMsgBytes() {
        return new Long(Destination.totalBytes());
    }

    public Long getTotalMsgBytesInDMQ() {
        return new Long(Destination.getDMQ().byteSize());
    }

    public ObjectName[] getDestinations() throws MBeanException {
        List list = DestinationUtil.getVisibleDestinations();
        if (list.size() == 0) {
            return null;
        }
        ObjectName[] objectNameArray = new ObjectName[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Destination destination = (Destination)list.get(i);
            try {
                ObjectName objectName;
                objectNameArray[i] = objectName = MQObjectName.createDestinationMonitor(destination.isQueue() ? "q" : "t", destination.getDestinationName());
                continue;
            }
            catch (Exception exception) {
                this.handleOperationException("getDestinations", exception);
            }
        }
        return objectNameArray;
    }

    public String getMBeanName() {
        return "DestinationManagerMonitor";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1191");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyDestinationCompact(Destination destination) {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.compact", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(destination.getDestinationName());
        destinationNotification.setDestinationType(destination.isQueue() ? "q" : "t");
        this.sendNotification(destinationNotification);
    }

    public void notifyDestinationCreate(Destination destination) {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.create", this, this.sequenceNumber++);
        boolean bl = !destination.isAutoCreated() && !destination.isInternal() && !destination.isDMQ() && !destination.isAdmin();
        destinationNotification.setDestinationName(destination.getDestinationName());
        destinationNotification.setDestinationType(destination.isQueue() ? "q" : "t");
        destinationNotification.setCreatedByAdmin(bl);
        this.sendNotification(destinationNotification);
    }

    public void notifyDestinationDestroy(Destination destination) {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.destroy", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(destination.getDestinationName());
        destinationNotification.setDestinationType(destination.isQueue() ? "q" : "t");
        this.sendNotification(destinationNotification);
    }

    public void notifyDestinationPause(Destination destination, String string) {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.pause", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(destination.getDestinationName());
        destinationNotification.setDestinationType(destination.isQueue() ? "q" : "t");
        destinationNotification.setPauseType(string);
        this.sendNotification(destinationNotification);
    }

    public void notifyDestinationPurge(Destination destination) {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.purge", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(destination.getDestinationName());
        destinationNotification.setDestinationType(destination.isQueue() ? "q" : "t");
        this.sendNotification(destinationNotification);
    }

    public void notifyDestinationResume(Destination destination) {
        DestinationNotification destinationNotification = new DestinationNotification("mq.destination.resume", this, this.sequenceNumber++);
        destinationNotification.setDestinationName(destination.getDestinationName());
        destinationNotification.setDestinationType(destination.isQueue() ? "q" : "t");
        this.sendNotification(destinationNotification);
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[5];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumDestinations", Integer.class.getName(), mbr.getString("MB1175"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("NumMsgs", Long.class.getName(), mbr.getString("MB1176"), true, false, false);
        Class clazz = Long.class;
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("NumMsgsInDMQ", clazz.getName(), mbr.getString("MB1177"), true, false, false);
        Class clazz2 = Long.class;
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("TotalMsgBytes", clazz2.getName(), mbr.getString("MB1178"), true, false, false);
        Class clazz3 = Long.class;
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("TotalMsgBytesInDMQ", clazz3.getName(), mbr.getString("MB1179"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[1];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getDestinations", mbr.getString("MB1190"), null, ObjectName;.class.getName(), 0);
        ops = mBeanOperationInfoArray;
        dstNotificationTypes = new String[]{"mq.destination.compact", "mq.destination.create", "mq.destination.destroy", "mq.destination.pause", "mq.destination.purge", "mq.destination.resume"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(dstNotificationTypes, DestinationNotification.class.getName(), mbr.getString("MB1133"));
        notifs = mBeanNotificationInfoArray;
    }
}

